#include <iostream>
#include <vector>

using namespace std;

int main() {
    int n, m;
    cin >> n >> m;

    vector<int> min_rows(n), max_rows(n);
    for (int i = 0; i < n; i++) {
        cin >> min_rows[i] >> max_rows[i];
    }

    vector<int> min_cols(m), max_cols(m);
    for (int j = 0; j < m; j++) {
        cin >> min_cols[j] >> max_cols[j];
    }

    long long max_potatoes = 0;
    for (int i = 0; i < n; i++) {
        int max_row = max_rows[i];
        int min_row = min_rows[i];
        for (int j = 0; j < m; j++) {
            int max_col = max_cols[j];
            int min_col = min_cols[j];
            int overlap = min(max_row, max_col) - max(min_row, min_col) + 1;
            if (overlap > 0) {
                max_potatoes += overlap;
            }
        }
    }
    cout << max_potatoes << endl;

    int k = 0;
    vector<vector<bool>> counted(n, vector<bool>(m, false));
    for (int i = 0; i < n; i++) {
        int max_row = max_rows[i];
        int min_row = min_rows[i];
        for (int j = 0; j < m; j++) {
            int max_col = max_cols[j];
            int min_col = min_cols[j];
            int overlap = min(max_row, max_col) - max(min_row, min_col) + 1;
            if (overlap > 0) {
                k++;
                counted[i][j] = true;
            }
        }
    }
    cout << k << endl;

    for (int i = 0; i < n; i++) {
        int max_row = max_rows[i];
        int min_row = min_rows[i];
        for (int j = 0; j < m; j++) {
            int max_col = max_cols[j];
            int min_col = min_cols[j];
            int overlap = min(max_row, max_col) - max(min_row, min_col) + 1;
            if (overlap > 0 && counted[i][j]) {
                int x = i+1, y = j+1;
                cout << x << " " << y << " " << overlap << endl;
            }
        }
    }

    return 0;
}